tinycc_client
=============

This is official client for URL shortening service Tiny.cc (REST API v3.1).
Tiny.cc API has 'batch_operations_limit' which limits number of URLs you can affect in group operations.
However, sometimes you need to overcome this limitation. This client provides transparant 
handling of 'batch_operations_limit' using jQuery deferred objects for parralel handling of multiply connections.

Detailed API documentation:
https://tinycc.com/tiny/api-docs

Installation
============
Just put file "tiny_client.js" to "js" directory on your server's webroot.
And add following code to <head> element of your HTML document:
<script src="/js/tiny_client.js"></script>

Quick Start
===========

Client instantiation:

	var client=new tinycc_client({
			api_root_url:"https://tinycc.com/tiny/api/3/",
			username:'johndow',
			api_key:'c3e49rce-ee35-44d9-a1bf-03522bd3b975',
		});

Simple shortening:

	client.shorten("https://yahoo.com").then(function(result){
		console.log(result);
	});

Mass shortening:

	client.mass_shorten(["https://yahoo.com","https://google.com"],{tags:'foo'}).then(function(result){
		console.log(result);
	});

Delete URL:

	client.select_with_hashes(["hrke"]).delete();

Create tag:

	client.create_tag('foo');

Tag URL:

	client.select_with_hashes(["hrke"].edit({tags:["+foo"]});

Untag URL:

	client.select_with_hashes(["hrke"]).edit({tags:["-foo"]});

Reset click stats of tagged URL:

	client.select_with_tags("foo").reset_stats();

Read first tagged URL:

	client.select_with_tags('foo').read({limit:1});	

Since APIv3.1, all operation (by default) performed on "default" domain.
To select different domain, use this code:

	client.set_working_domain("my-domain.com");
	
Operations with tags, work across domains.


Methods summary
===============

Following methods, do not require preliminary selection of URLs:

set_working_domain(string domain) - switch current domain context
account_info() - user account information. Including API usage.
shorten(string long_url, object data) - shorten single URL (with optional custom properties)
read_page(object params) - read paginated index of shortened URLs
mass_shorten(array long_urls, object data) - shorten many URLs (with optional custom properties)
tags() - read list of available tags
domains() - read list of available domains
create_tag(label) - create new tag
delete_tag(label) - delete tag (tagged URLs won't be deleted)

Selection methods (chainable):

select_with_hashes(array hashes)
select_with_tags(string tags_query)

Following methods require preliminary selection of URLs:

read(object params) - read properties of selected URL(s). Expect the same parameters as read_page().
edit(object data) - change properties of selected URL(s). Will return updated URL(s) data when selecting with hashes.
delete() - delete selected URL(s)
reset_stats() - reset clicks stats for selected URL(s)

All methods return jQuery promise object. You can use it as follows:

	var promise = client.shorten("https://yahoo.com");
	
	promise.then(
		function(result){ // success handler
			console.log(result);
		},
		function(result){ // error handler
			console.log(result);
		}
	);


