using System.Diagnostics.CodeAnalysis;
using Newtonsoft.Json;

namespace Tinycc.Resources;

[ExcludeFromCodeCoverage]
public class AccountResponse
{
    public static readonly string DataItem = "account";

    [JsonProperty("account_expiration_date")]
    public DateTime? AccountExpiration { get; set; }

    [JsonProperty("counters")]
    public AccountCounters Counters { get; set; }

    [JsonProperty("subscription_plan")]
    public string SubscriptionPlan { get; set; }

    [JsonProperty("user_id")]
    public string UserId { get; set; }

    [JsonProperty("username")]
    public string Username { get; set; }

    public class AccountCounters
    {
        [JsonProperty("urls")]
        public AccountCounter Urls { get; set; }

        [JsonProperty("today_api_calls")]
        public AccountCounter TodayApiCalls { get; set; }

        [JsonProperty("month_urls")]
        public AccountCounter MonthUrls { get; set; }

        [JsonProperty("daily_redirects")]
        public AccountCounter DailyRedirects { get; set; }
    }

    public class AccountCounter
    {
        [JsonProperty("count")]
        public int? Count { get; set; }

        [JsonProperty("limit")]
        public int? Limit { get; set; }
    }
}
