using System.Diagnostics.CodeAnalysis;
using Newtonsoft.Json;

namespace Tinycc.Resources;

[ExcludeFromCodeCoverage]
public class ReadResponse
{
    public static readonly string DataItem = "urls";

    [JsonProperty("urls")]
    public IEnumerable<Url> Urls { get; set; }

    public PageInfo Page { get; set; }

    public class PageInfo
    {
        [JsonProperty("offset")]
        public int? Offset { get; set; }

        [JsonProperty("results_count")]
        public int? ResultsCount { get; set; }

        [JsonProperty("total_count")]
        public int? TotalCount { get; set; }
    }
}
