<?php
/**
 * Tiny.cc REST API v3 client
 * 
 * This client works with tiny.cc URL shortening services using API v3.
 * 
 * @copyright	2015 Tiny.cc
 * @author		Alexey Gorshunov <ag@blazing.pro>
 * @license		MIT
 * @package		tinycc/client
 */
 
namespace tinycc;

/**
 * Custom exception thrown by client
 */
class classic_client_exception
	extends \Exception
{
	static function missing_selection($method)
	{
		return new static("{$method} requires premature selection of URLs");
	}

	static function invalid_argument($method, $arg)
	{
		return new static("Client error: invalid or missing argument '{$arg}' in {$method}");
	}
	
	static function curl_error($curl)
	{
		return new static("cURL error: ".curl_error($curl) . '(' . curl_errno($curl) . ')');
	}

	static function api_error($message, $code=0)
	{
		return new static("Tiny API error: {$message} ({$code})", $code);
	}
	
	static function client_error($message)
	{
		return new static("Client error: {$message}");
	}
}

